#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;
#include maps\mp\gametypes\common_sd_sr;
#include maps\mp\gametypes\sd;
#include maps\mp\gametypes\_gamelogic;
#include maps\mp\gametypes\_damage;
#include maps\mp\gametypes\_class;

init(){
    precachemodel( "equip_iw4_throwingknife_npc" );
    replacefunc(maps\mp\gametypes\_weapons::throwingknifeusage, ::autoPickupThrowingKnife);
    replacefunc(maps\mp\gametypes\_gamelogic::matchstarttimer_internal, ::gf_matchstarttimer_internal);
    replacefunc(maps\mp\gametypes\_gamelogic::matchstarttimer, ::gf_matchstarttimer);
    replacefunc(maps\mp\gametypes\_killcam::dofinalkillcamfx, ::gf_dofinalkillcamfx);
    replacefunc(maps\mp\gametypes\_killcam::killcam, ::gf_killcam);
    //replacefunc(maps\mp\gametypes\_killcam::killcamtime, ::gf_killcamtime);
    replacefunc(maps\mp\gametypes\common_sd_sr::bombs, ::gf_bombs);
    replacefunc(maps\mp\gametypes\_damage::callback_playerdamage_internal, ::gf_callback_playerdamage_internal);
    replacefunc(maps\mp\gametypes\_damage::callback_playerkilled, ::gf_callback_playerkilled);
    replacefunc(maps\mp\gametypes\sd::onstartgametype, ::gf_onstartgametype);
    replacefunc(maps\mp\gametypes\_gamelogic::callback_startgametype, ::gf_callback_startgametype);
    replacefunc(maps\mp\gametypes\_music_and_dialog::roundwinnerdialog, ::gf_roundwinnerdialog);
    replacefunc(maps\mp\gametypes\common_sd_sr::ontimelimit, ::gf_ontimelimit);
    replacefunc(maps\mp\gametypes\common_sd_sr::sd_endgame, ::gf_sd_endgame);
    //replacefunc(maps\mp\gametypes\_gamescores::updateteamscore, ::gf_updateteamscore);
    replacefunc(maps\mp\gametypes\_gamelogic::timelimitclock, ::gf_timelimitclock);
    replacefunc(maps\mp\gametypes\_gamelogic::endgame, ::gf_endgame);
    replacefunc(maps\mp\gametypes\_gamelogic::forceend, ::gf_forceend);
    replacefunc(maps\mp\gametypes\_gamelogic::freegameplayhudelems, ::gf_freegameplayhudelems);
    replacefunc(maps\mp\gametypes\_hud_message::initnotifymessage, ::gf_initnotifymessage);
    //replacefunc(maps\mp\gametypes\_menus::menugiveclass, ::gf_menugiveclass);
    replacefunc(maps\mp\_flashgrenades::monitorflash, ::gf_monitorflash);
    replacefunc(maps\mp\gametypes\_class::applyloadout, ::gf_applyloadout);

    //replacefunc(maps\mp\_utility::waslastround, ::gf_waslastround);

    replacefunc(maps\mp\gametypes\_playerlogic::setuioptionsmenu, ::gf_setuioptionsmenu);
    //replacefunc(maps\mp\gametypes\_menus::showloadoutmenu, ::gf_showloadoutmenu);

    game["dialog"]["gametype"] = "";
    game["dialog"]["defense_obj"] = "gbl_start";
    game["dialog"]["offense_obj"] = "gbl_start";

    user_scripts\mp_patches\gunfight\game::init();
}

gf_waslastround()
{
    if ( level.forcedend )
        return 1;

    if ( !level.teambased )
        return 1;

    if ( hitroundlimit() || hitwinlimit() )
        return 1;

    return 0;
}

gf_setuioptionsmenu(var_0){
    self endon( "disconnect" );
    self endon( "joined_spectators" );

    while ( self ismlgspectator() && !maps\mp\_utility::invirtuallobby() )
        waitframe();
    if(var_0 == 2)
        var_0 = -1;
    self setclientomnvar( "ui_options_menu", var_0 );
    //self iPrintLnBold(var_0);
}

gf_showloadoutmenu()
{
    self endon( "disconnect" );
    level endon( "game_ended" );
    common_scripts\utility::waittill_any( "joined_team", "selected_same_team" );

    if ( maps\mp\_utility::ishodgepodgeph() && !maps\mp\_utility::allowclasschoice() )
        return;

    //self setclientomnvar( "ui_options_menu", 2 );
}

gf_applyloadout( var_0, var_1, var_2, var_3 )
{
    self.primaryweapon = "h2_ump45_mp";
    self.secondaryweapon = "h2_glock_mp";
    self.meleeweapon = var_1;
    self setmovespeedscale( 1.0 );
    self notify( "changed_kit" );
    self notify( "applyLoadout" );
}

gf_initnotifymessage(){

}

gf_freegameplayhudelems()
{
    if ( isdefined( self.perkicon ) )
    {
        if ( isdefined( self.perkicon[0] ) )
        {
            self.perkicon[0] maps\mp\gametypes\_hud_util::destroyelem();
            self.perkname[0] maps\mp\gametypes\_hud_util::destroyelem();
        }

        if ( isdefined( self.perkicon[1] ) )
        {
            self.perkicon[1] maps\mp\gametypes\_hud_util::destroyelem();
            self.perkname[1] maps\mp\gametypes\_hud_util::destroyelem();
        }

        if ( isdefined( self.perkicon[2] ) )
        {
            self.perkicon[2] maps\mp\gametypes\_hud_util::destroyelem();
            self.perkname[2] maps\mp\gametypes\_hud_util::destroyelem();
        }
    }
    self notify( "perks_hidden" );
    
    if ( isdefined( self.notifytitle ) )
        self.notifytitle maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.notifytext ) )
        self.notifytext maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.notifytext2 ) )
        self.notifytext2 maps\mp\gametypes\_hud_util::destroyelem();

        if ( isdefined( self.notifytext2 ) )
        self.notifytext2 maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.notifyicon ) )
        self.notifyicon maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.notifyoverlay ) )
        self.notifyoverlay maps\mp\gametypes\_hud_util::destroyelem();
    
    //if ( isdefined( self.lowermessage ) )
    //    self.lowermessage maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.lowertimer ) )
        self.lowertimer maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.proxbar ) )
        self.proxbar maps\mp\gametypes\_hud_util::destroyelem();

    if ( isdefined( self.proxbartext ) )
        self.proxbartext maps\mp\gametypes\_hud_util::destroyelem();
}

gf_monitorflash()
{
    self endon( "disconnect" );
    self notify( "monitorFlash" );
    self endon( "monitorFlash" );
    self.flashendtime = 0;
    var_0 = 6;

    for (;;)
    {
        self waittill( "flashbang", var_1, var_2, var_3, var_4, var_5, var_6 );

        if ( !isalive( self ) )
            continue;

        if ( isdefined( self.usingremote ) )
            continue;

        if ( !isdefined( var_6 ) )
            var_6 = 0;

        var_7 = 0;
        var_8 = 1;

        if ( var_3 < 0.5 )
            var_3 = 0.5;
        else if ( var_3 > 0.8 )
            var_3 = 1;

        var_9 = var_2 * var_3 * var_0;
        var_9 += var_6;

        if ( isdefined( self.stunscaler ) )
            var_9 *= self.stunscaler;

        if ( var_9 < 0.25 )
            continue;

        var_10 = undefined;

        if ( var_9 > 2 )
            var_10 = 0.75;
        else
            var_10 = 0.25;

        if ( level.teambased && isdefined( var_4 ) && isdefined( var_4.team ) && var_4.team == self.team && var_4 != self )
        {
            if ( level.friendlyfire == 0 )
                continue;
            else if ( level.friendlyfire == 1 )
            {

            }
            else if ( level.friendlyfire == 2 )
            {
                var_9 *= 0.5;
                var_10 *= 0.5;
                var_8 = 0;
                var_7 = 1;
            }
            else if ( level.friendlyfire == 3 )
            {
                var_9 *= 0.5;
                var_10 *= 0.5;
                var_7 = 1;
            }
        }
        else if ( isdefined( var_4 ) )
        {
            if ( var_4 != self )
                var_4 maps\mp\gametypes\_missions::processchallenge( "ch_flash" );

            var_11 = maps\mp\_utility::getmapname();

            if ( var_11 == "mp_crash_snow" )
                var_4 maps\mp\gametypes\_missions::processchallenge( "ch_wc_tactical" );
            else if ( var_11 == "mp_farm_spring" )
                var_4 maps\mp\gametypes\_missions::processchallenge( "ch_stpatty_tactical" );
            else if ( var_11 == "mp_bog_summer" )
                var_4 maps\mp\gametypes\_missions::processchallenge( "ch_summer_tactical" );
        }

        if ( var_8 && isdefined( self ) )
        {
            thread maps\mp\_flashgrenades::applyflash( var_9, var_10 );

            self.health -= 1;

            if ( isdefined( var_4 ) && var_4 != self )
            {
                var_4 thread maps\mp\gametypes\_damagefeedback::updatedamagefeedback( "flash" );
                self.flashattacker = var_4;
                var_12 = self;

                if ( isplayer( var_4 ) && var_4 isitemunlocked( "specialty_paint" ) && var_4 maps\mp\_utility::_hasperk( "specialty_paint" ) )
                    var_12 thread maps\mp\perks\_perkfunctions::setpainted( var_4 );
            }
            else
                self.flashattacker = undefined;
        }

        if ( var_7 && isdefined( var_4 ) )
            var_4 thread maps\mp\_flashgrenades::applyflash( var_9, var_10 );
    }
}

gf_forceend()
{
    wait 2;
    executecommand("fast_restart");
}

gf_killcamtime( killcamentitystarttime, sWeapon, predelay, timeUntilRespawn, maxtime, var_5, showingFinalKillcam, attacker, victim)
{
    if ( getdvar( "scr_killcam_time" ) == "" )
    {
        var_7 = maps\mp\_utility::strip_suffix( sWeapon, "_lefthand" );

        if ( var_5 || sWeapon == "artillery_mp" )
            camtime = ( gettime() - killcamentitystarttime ) / 1000 - predelay - 0.1;
        else if ( showingFinalKillcam )
            camtime = 4.0;
        else if ( issubstr( sWeapon, "remotemissile_" ) )
            camtime = 5;
        else if ( !timeUntilRespawn )
            camtime = 5.0;
        else if ( var_7 == "h1_fraggrenade_mp" || var_7 == "h1_fraggrenadeshort_mp" )
            camtime = 4.25;
        else
            camtime = 2.5;
    }
    else
        camtime = getdvarfloat( "scr_killcam_time" );

    if(showingFinalKillcam){
		highestTime = 0;
		foreach ( player in level.players ){
			if(player.team != attacker.team && !isAlive(player)){
				deathTimeDiff = (victim.deathTime - player.deathTime);
				//iprintln(player.name+": "+deathTimeDiff);
				//logprint("\n--------------\n"+player.name + "'s last known Attacker" +player.lastAttacker.name);
				if(player.lastAttacker == attacker && deathTimeDiff < 10000 && deathTimeDiff > (camtime*1000)){
					if(deathTimeDiff > highestTime)
						highestTime = (victim.deathTime - player.deathTime);
				}
			}
		}
		camtime += (highestTime/1000);
	}

    if(camtime == maxtime)
		camtime = 4;

    if ( var_5 && camtime > 5 )
        camtime = 5;

    if ( isdefined( maxtime ) )
    {
        if ( camtime > maxtime )
            camtime = maxtime;

        if ( camtime < 0.05 )
            camtime = 0.05;
    }

    return camtime;
}

gf_killcam( var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_11, var_12, var_13, var_14, var_15, var_16, var_17, var_18 )
{
    //var_4 = sWeapon
    //iPrintLn("Attacker: "+var_13.name);
    //iPrintLn("Victim: "+var_14.name);
    //wait 1;
    self endon( "disconnect" );
    self endon( "spawned" );
    level endon( "game_ended" );

    if ( var_1 < 0 || !isdefined( var_13 ) )
        return;

    level.numplayerswaitingtoenterkillcam++;
    var_19 = level.numplayerswaitingtoenterkillcam * 0.05;

    if ( level.numplayerswaitingtoenterkillcam > 1 )
        wait(0.05 * ( level.numplayerswaitingtoenterkillcam - 1 ));

    wait 0.05;
    level.numplayerswaitingtoenterkillcam--;
    var_20 = gf_killcamtime( var_3, var_4, var_8, var_11, var_12, var_18, level.showingfinalkillcam, var_13, var_14 );

    if ( getdvar( "scr_killcam_posttime" ) == "" )
        var_21 = 2;
    else
    {
        var_21 = getdvarfloat( "scr_killcam_posttime" );

        if ( var_21 < 0.05 )
            var_21 = 0.05;
    }

    var_22 = var_20 + var_21;

    if ( isdefined( var_12 ) && var_22 > var_12 )
    {
        if ( var_12 < 2 )
            return;

        if ( var_12 - var_20 >= 1 )
            var_21 = var_12 - var_20;
        else
        {
            var_21 = 1;
            var_20 = var_12 - 1;
        }

        var_22 = var_20 + var_21;
    }

    self setclientomnvar( "ui_killcam_end_milliseconds", 0 );

    if ( isagent( var_13 ) && !isdefined( var_13.isactive ) )
        return;

    if ( isplayer( var_14 ) )
        self setclientomnvar( "ui_killcam_victim_id", var_14 getentitynumber() );
    else
        self setclientomnvar( "ui_killcam_victim_id", -1 );

    if ( isplayer( var_13 ) )
        self setclientomnvar( "ui_killcam_killedby_id", var_13 getentitynumber() );
    else if ( isagent( var_13 ) )
        self setclientomnvar( "ui_killcam_killedby_id", -1 );

    if ( maps\mp\_utility::iskillstreakweapon( var_4 ) )
    {
        var_23 = maps\mp\_utility::getkillstreakrownum( level.killstreakwieldweapons[var_4] );
        self setclientomnvar( "ui_killcam_killedby_killstreak", var_23 );
        self setclientomnvar( "ui_killcam_killedby_weapon", -1 );
        self setclientomnvar( "ui_killcam_killedby_weapon_custom", -1 );
        self setclientomnvar( "ui_killcam_killedby_weapon_alt", 0 );
        self setclientomnvar( "ui_killcam_copycat", 0 );
    }
    else
    {
        var_24 = [];
        var_25 = getweaponbasename( var_4 );

        if ( isdefined( var_25 ) )
        {
            if ( maps\mp\_utility::ismeleemod( var_15 ) && !maps\mp\gametypes\_weapons::isriotshield( var_4 ) )
                var_25 = "iw5_combatknife";
            else
            {
                var_25 = maps\mp\_utility::strip_suffix( var_25, "_lefthand" );
                var_25 = maps\mp\_utility::strip_suffix( var_25, "_mp" );
            }

            self setclientomnvar( "ui_killcam_killedby_weapon", var_5 );
            self setclientomnvar( "ui_killcam_killedby_weapon_custom", var_6 );
            self setclientomnvar( "ui_killcam_killedby_weapon_alt", var_7 );
            self setclientomnvar( "ui_killcam_killedby_killstreak", -1 );

            if ( var_25 != "iw5_combatknife" )
                var_24 = getweaponattachments( var_4 );

            self setclientomnvar( "ui_killcam_copycat", 0 );
        }
        else
        {
            self setclientomnvar( "ui_killcam_killedby_weapon", -1 );
            self setclientomnvar( "ui_killcam_killedby_weapon_custom", -1 );
            self setclientomnvar( "ui_killcam_killedby_weapon_alt", 0 );
            self setclientomnvar( "ui_killcam_killedby_killstreak", -1 );
            self setclientomnvar( "ui_killcam_copycat", 0 );
        }
    }

    if ( isplayer( var_14 ) && var_14.pers["nemesis_guid"] == var_13.guid && var_14.pers["nemesis_tracking"][var_13.guid] >= 2 )
        self setclientomnvar( "ui_killcam_killedby_nemesis", 1 );
    else
        self setclientomnvar( "ui_killcam_killedby_nemesis", 0 );

    if ( !var_11 && !level.gameended )
        self setclientomnvar( "ui_killcam_text", "skip" );
    else if ( !level.gameended )
        self setclientomnvar( "ui_killcam_text", "respawn" );
    else
        self setclientomnvar( "ui_killcam_text", "none" );

    switch ( var_16 )
    {
        case "score":
            self setclientomnvar( "ui_killcam_type", 1 );
            break;
        case "normal":
        default:
            self setclientomnvar( "ui_killcam_type", 0 );
            break;
    }

    var_26 = var_20 + var_8 + var_19;
    var_27 = gettime();
    self notify( "begin_killcam", var_27 );

    if ( !isagent( var_13 ) && isdefined( var_13 ) && isplayer( var_14 ) )
        var_13 visionsyncwithplayer( var_14 );

    maps\mp\_utility::updatesessionstate( "spectator" );
    self.spectatekillcam = 1;

    if ( isagent( var_13 ) )
        var_1 = var_14 getentitynumber();

    self onlystreamactiveweapon( 0 );
    self.forcespectatorclient = var_1;
    self.killcamentity = -1;
    var_28 = maps\mp\gametypes\_killcam::setkillcamerastyle( var_0, var_1, var_2, var_4, var_14, var_20 );

    if ( !var_28 )
        thread maps\mp\gametypes\_killcam::setkillcamentity( var_2, var_26, var_3 );

    var_17 = maps\mp\gametypes\_killcam::killcamadjustalivetime( var_17, var_1, var_2 );

    if ( var_26 > var_17 )
        var_26 = var_17;

    self.archivetime = var_26;
    self.killcamlength = var_22;
    self.psoffsettime = var_9;
    self allowspectateteam( "allies", 1 );
    self allowspectateteam( "axis", 1 );
    self allowspectateteam( "freelook", 1 );
    self allowspectateteam( "none", 1 );

    if ( level.multiteambased )
    {
        foreach ( var_30 in level.teamnamelist )
            self allowspectateteam( var_30, 1 );
    }

    foreach ( var_30 in level.teamnamelist )
        self allowspectateteam( var_30, 1 );

    thread maps\mp\gametypes\_killcam::endedkillcamcleanup();
    wait 0.05;

    if ( !isdefined( self ) )
        return;

    if ( self.archivetime < var_26 )
    {

    }

    var_20 = self.archivetime - 0.05 - var_8;
    var_22 = var_20 + var_21;
    self.killcamlength = var_22;

    if ( var_20 <= 0 )
    {
        maps\mp\_utility::updatesessionstate( "dead" );
        maps\mp\_utility::clearkillcamstate();
        self notify( "killcam_ended" );
        return;
    }

    self setclientomnvar( "ui_killcam_end_milliseconds", int( var_22 * 1000 ) + gettime() );

    if ( level.showingfinalkillcam )
        thread gf_dofinalkillcamfx( var_20, var_2 );

    self.killcam = 1;
    thread maps\mp\gametypes\_killcam::spawnedkillcamcleanup();
    self.skippedkillcam = 0;
    self.killcamstartedtimedeciseconds = maps\mp\_utility::gettimepasseddecisecondsincludingrounds();

    if ( !level.showingfinalkillcam )
        thread maps\mp\gametypes\_killcam::waitskipkillcambutton( var_10 );
    else
        self notify( "showing_final_killcam" );

    thread maps\mp\gametypes\_killcam::endkillcamifnothingtoshow();
    maps\mp\gametypes\_killcam::waittillkillcamover();

    if ( level.showingfinalkillcam )
    {
        if ( self == var_13 )
            var_13 maps\mp\gametypes\_missions::processchallenge( "ch_moviestar" );

        thread maps\mp\gametypes\_playerlogic::spawnendofgame();
        return;
    }

    thread maps\mp\gametypes\_killcam::killcamcleanup( 1 );
}

gf_menugiveclass( var_0 )
{
    /*if(self.team == "allies"){
        self maps\mp\gametypes\_menus::addToTeam( "axis" );
        self _suicide();
    }
    else if(self.team == "axis"){
        self maps\mp\gametypes\_menus::addToTeam( "allies" );
        self _suicide();
    }*/
    self setclientomnvar( "ui_options_menu", 1 );
}

gf_callback_playerkilled( var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7, var_8 )
{
    level.doSlowMo = false;
    if(!var_1 isOnGround())
        level.doSlowMo = true;
    else
        level.doSlowMo = false;
    maps\mp\gametypes\_damage::playerkilled_internal( var_0, var_1, self, var_2, var_3, var_4, var_5, var_6, var_7, var_8, 0, 0 );
}

autoPickupThrowingKnife(){
	self endon("death");
	self endon("disconnect");
	for(;;){
		self waittill("grenade_fire", grenade, weaponName);
        if(isdefined(grenade) && weaponName == "iw9_throwknife_mp"){
            grenade thread waitForStick();
        }
	}
}

waitForStick(){
	self waittill("missile_stuck");
	oldOrigin = undefined;
	while(self.origin != oldOrigin){
        oldOrigin = self.origin;
        wait 1;
    }
	pos = self.origin;
	model = spawn( "script_model", pos );
	model setModel("equip_iw4_throwingknife_npc");
	model.angles = self.angles;
	trigger = spawn( "trigger_radius", pos-(0,0,45), 0, 30, 50 );
	trigger thread watchTimeout(model);
	self delete();
	while(isdefined(trigger))
	{
		trigger waittill( "trigger", player );
		if(Distance(pos, player getTagOrigin("j_head")) <= 75 && player hasWeapon("iw9_throwknife_mp") && player getammocount("iw9_throwknife_mp") == 0)
		{
			player setlethalweapon("iw9_throwknife_mp");
			player maps\mp\gametypes\_class::giveoffhand("iw9_throwknife_mp");
			player setWeaponAmmoClip("iw9_throwknife_mp", 1);
			player playLocalSound("h2_scavenger_pack_pickup");
			trigger notify("deleted");
			model delete();
			trigger delete();
		}
		wait 0.025;
	}
}

watchTimeout(model){
	self endon("deleted");
	wait 60;
	model delete();
	self delete();
}

gf_dofinalkillcamfx( var_0, var_1 )
{
    if(level.doSlowMo || getDvarInt("gf_killcamslowmo") == 1){
        if ( isdefined( level.doingfinalkillcamfx ) )
            return;

        level.doingfinalkillcamfx = 1;
        var_2 = var_0;

        if ( var_2 > 1.0 )
        {
            var_2 = 1.0;
            wait(var_0 - 1.0);
        }

        setslowmotion( 1.0, 0.25, var_2 );
        wait(var_2 + 0.5);
        setslowmotion( 0.25, 1, 1.0 );
    }
    level.doingfinalkillcamfx = undefined;
}

gf_callback_playerdamage_internal( var_0, var_1, var_2, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10 )
{
                            //eInflictor, eAttacker, victim, iDamage, iDFlags, sMeansOfDeath, sWeapon, vPoint, vDir, sHitLoc, psOffsetTime
    //iprintln("sWeapon: " + var_6);
	//iprintln("locaiton: " + var_9);
    if(level.devMode)
	    iprintln("Before iDamage: " + var_3);
	/*if(!level.allowDamage && var_1.team != var_2.team){
		var_1 iprintlnBold("^3Spawn Protection!");
		return;
	}*/
	if(
	!isSubStr( var_6, "h1_c4_mp" ) &&
	!isSubStr( var_6, "h1_claymore_mp" ) &&
	!isSubStr( var_6, "h2_semtex_mp" ) &&
	!isSubStr( var_6, "h1_fraggrenade_mp" ) &&
	!isSubStr( var_6, "h1_concussiongrenade_mp" ) &&
	!isSubStr( var_6, "h1_flashgrenade_mp" ) &&
	!isSubStr( var_6, "iw9_throwknife_mp" ) &&
	!isSubStr( var_6, "h1_smokegrenade_mp" ) &&
	!isSubStr( var_6, "shotgun_attach_mp" ) &&
    !isSubStr( var_5, "MOD_FALLING" ) &&
	!isSubStr( var_5, "MOD_MELEE" )
	){
        var_3 = int(var_3/getdvarfloat("gf_damageNerf"));
        //var_3 = var_3;
    }

    if(isSubStr( var_5, "MOD_FALLING" )){
        if(level.loudout["perk"]["3"] == "specialty_commando_pro")
            var_3 = 0;
        else
            var_3 = int(var_3/getdvarfloat("gf_damageNerf"));

        var_3 = 0;
    }
        


	if(isSubStr( var_6, "raygun" ) ){
		if(var_9 == "head")
			var_3 = getDvarInt("gf_maxhealth");
		else
			var_3 = (var_3/45);
	}

	if(
	isSubStr( var_6, "shotgun_attach_mp" ) ||
	isSubStr( var_6, "shotgun_attach_mp" )
	)
		var_3 = (var_3*1.1);

	if(
	isSubStr( var_6, "h1_flashgrenade_mp" ) ||
	isSubStr( var_6, "h1_concussiongrenade_mp" ) ||
	isSubStr( var_6, "h1_smokegrenade_mp" )
	)
		var_3 = 1;

	if(
	isSubStr( var_6, "m40a3_" ) ||
	isSubStr( var_6, "cheytac_") ||
    isSubStr( var_6, "l118a_") ||
	isSubStr( var_6, "awp_") ||
	isSubStr( var_6, "ballista_") ||
	isSubStr( var_6, "dsr_") ||
	isSubStr( var_6, "kar98_") ||
	isSubStr( var_6, "koshka_") ||
	isSubStr( var_6, "l96a1_") ||
	isSubStr( var_6, "locus_") ||
	isSubStr( var_6, "lynx_") ||
	isSubStr( var_6, "m200_") ||
	isSubStr( var_6, "arisaka_") ||
	isSubStr( var_6, "usr_") ||
	isSubStr( var_6, "mors_") ||
	isSubStr( var_6, "msr_") ||
	isSubStr( var_6, "outlaw_") ||
	isSubStr( var_6, "r700_") ||
	isSubStr( var_6, "rsa_") ||
	isSubStr( var_6, "stac_") ||
	(isSubStr( var_6, "barrett_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
	(isSubStr( var_6, "as50_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
    (isSubStr( var_6, "m21_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
    (isSubStr( var_6, "d25s_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
	(isSubStr( var_6, "rsass_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
	(isSubStr( var_6, "psg1_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
	(isSubStr( var_6, "ptrs_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
	(isSubStr( var_6, "xpr50_") && ( var_9 == "head" || var_9 == "neck" || var_9 == "torso_upper" || var_9 == "torso_lower")) ||
	(isSubStr( var_6, "dragunov") && ( var_9 == "head" || var_9 == "neck")) ||
	(isSubStr( var_6, "m1irons") && ( var_9 == "head")) ||
	(isSubStr( var_6, "deserteagle") && ( var_9 == "head")) ||
	(isSubStr( var_6, "deserteaglegold") && ( var_9 == "head" ))
	)
        var_3 = getDvarInt("gf_maxhealth");

	if(var_5 == "MOD_MELEE" )
		var_3 = getDvarInt("gf_maxhealth")/2;
		
	/*if(var_6 == level.loudout["weapons"]["secondary"] && getDvar("forced_weapon") == "bolt" || isSubStr( var_5, "MOD_MELEE" ) && getDvar("forced_weapon") == "bolt"){
        var_3 = 0;
        var_1 iprintlnBold("^3Bolt Actions Only!");
    }*/

    if(level.devMode){
        iprintln("After iDamage: " + var_3);
    }
	    
	//iprintln("iDamage: " + var_3);
    //iPrintLn("Damage: "+var_3+" - From: "+var_1.name + " - Weapon:"+ var_6);
    logprint("Damage: "+var_3+" - From: "+var_1.name + " - Weapon:"+ var_6);

    if ( getdvarint( "virtuallobbyactive", 0 ) )
        return "virtuallobbyactive";

    var_1 = maps\mp\_utility::_validateattacker( var_1 );
    var_11 = maps\mp\_utility::strip_suffix( var_6, "_lefthand" );

    if ( isdefined( var_5 ) && var_5 == "MOD_CRUSH" && isdefined( var_0 ) && isdefined( var_0.classname ) && var_0.classname == "script_vehicle" )
        return "crushed";

    if ( !maps\mp\_utility::isreallyalive( var_2 ) && !isdefined( var_2.inliveplayerkillstreak ) )
        return "!isReallyAlive( victim )";

    if ( isdefined( var_1 ) && var_1.classname == "script_origin" && isdefined( var_1.type ) && var_1.type == "soft_landing" )
        return "soft_landing";

    if ( var_2 ishardwrireprotected( var_6 ) )
        return "specialty_stun_resistance";

    if ( isdefined( level.hostmigrationtimer ) )
        return "level.hostMigrationTimer";

    if ( var_5 == "MOD_FALLING" )
        var_2 thread emitfalldamage( var_3 );

    if ( var_5 == "MOD_EXPLOSIVE_BULLET" && var_3 != 1 )
    {
        var_3 *= getdvarfloat( "scr_explBulletMod" );
        var_3 = int( var_3 );
    }

    if ( isdefined( var_1 ) && var_1.classname == "worldspawn" )
        var_1 = undefined;

    if ( isdefined( var_1 ) && isdefined( var_1.gunner ) )
        var_1 = var_1.gunner;

    var_12 = maps\mp\_utility::attackerishittingteam( var_2, var_1 );
    var_13 = isdefined( var_1 ) && isdefined( var_0 ) && isdefined( var_2 ) && isplayer( var_1 ) && var_1 == var_0 && var_1 == var_2 && !isdefined( var_0.poison );

    if ( var_13 )
        return "attackerIsInflictorVictim";

    var_14 = 0.0;

    if ( var_4 & level.idflags_stun )
    {
        var_14 = 0.0;
        var_3 = 0.0;
    }
    else if ( var_9 == "shield" )
    {
        if ( var_12 && level.friendlyfire == 0 )
            return "attackerIsHittingTeammate";

        if ( var_5 == "MOD_PISTOL_BULLET" || var_5 == "MOD_RIFLE_BULLET" || var_5 == "MOD_EXPLOSIVE_BULLET" && !var_12 )
        {
            if ( isplayer( var_1 ) )
            {
                var_1.lastattackedshieldplayer = var_2;
                var_1.lastattackedshieldtime = gettime();
            }

            if ( maps\mp\_utility::isenvironmentweapon( var_6 ) )
                var_16 = 25;
            else
                var_16 = maps\mp\perks\_perks::cac_modified_damage( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

            var_2.shielddamage += var_16;

            if ( !maps\mp\_utility::isenvironmentweapon( var_6 ) || common_scripts\utility::cointoss() )
                var_2.shieldbullethits++;

            if ( var_2.shieldbullethits >= level.riotshieldxpbullets )
            {
                var_2.shielddamage = 0;
                var_2.shieldbullethits = 0;
            }
        }

        if ( var_4 & level.idflags_shield_explosive_impact )
        {
            var_9 = "none";

            if ( !( var_4 & level.idflags_shield_explosive_impact_huge ) )
                var_3 *= 0.0;
        }
        else if ( var_4 & level.idflags_shield_explosive_splash )
        {
            if ( isdefined( var_0 ) && isdefined( var_0.stuckenemyentity ) && var_0.stuckenemyentity == var_2 )
                var_3 = 51;

            var_9 = "none";
        }
        else
            return "hit shield";
    }
    else if ( maps\mp\_utility::ismeleemod( var_5 ) && issubstr( var_6, "riotshield" ) )
    {
        if ( !( var_12 && level.friendlyfire == 0 ) )
        {
            var_14 = 0.0;
            var_2 stunplayer( 0.0 );
        }
    }

    if ( !var_12 )
        var_3 = maps\mp\perks\_perks::cac_modified_damage( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9, var_0 );

    if ( isdefined( level.modifyplayerdamage ) )
        var_3 = [[ level.modifyplayerdamage ]]( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

    var_17 = isdefined( var_1 ) && !isdefined( var_1.gunner ) && ( var_1.classname == "script_vehicle" || var_1.classname == "misc_turret" || var_1.classname == "script_model" );
    var_12 = maps\mp\_utility::attackerishittingteam( var_2, var_1 );

    if ( !var_3 )
        return "!iDamage";

    var_2.idflags = var_4;
    var_2.idflagstime = gettime();

    if ( game["state"] == "postgame" )
        return "game[ state ] == postgame";

    if ( var_2.sessionteam == "spectator" )
        return "victim.sessionteam == spectator";

    if ( isdefined( var_2.candocombat ) && !var_2.candocombat )
        return "!victim.canDoCombat";

    if ( isdefined( var_1 ) && isplayer( var_1 ) && isdefined( var_1.candocombat ) && !var_1.candocombat )
        return "!eAttacker.canDoCombat";

    if ( isdefined( var_1 ) && isalive( var_1 ) && !isdefined( var_1.perkoutlined ) )
        var_1.perkoutlined = 0;

    if ( var_17 && var_12 )
    {
        if ( var_5 == "MOD_CRUSH" )
        {
            var_2 maps\mp\_utility::_suicide();
            return "suicide crush";
        }

        if ( !level.friendlyfire )
            return "!level.friendlyfire";
    }

    if ( isai( self ) )
        self [[ level.bot_funcs["on_damaged"] ]]( var_1, var_3, var_5, var_6, var_0, var_9 );

    if ( !isdefined( var_8 ) )
        var_4 |= level.idflags_no_knockback;

    var_18 = 0;

    if ( var_2.health == var_2.maxhealth && ( !isdefined( var_2.laststand ) || !var_2.laststand ) || !isdefined( var_2.attackers ) && !isdefined( var_2.laststand ) )
    {
        var_2.attackers = [];
        var_2.attackerdata = [];
    }

    if ( maps\mp\_utility::isheadshot( var_6, var_9, var_5, var_1 ) )
        var_5 = "MOD_HEAD_SHOT";

    if ( maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "onlyheadshots" ) )
    {
        if ( var_5 == "MOD_PISTOL_BULLET" || var_5 == "MOD_RIFLE_BULLET" || var_5 == "MOD_EXPLOSIVE_BULLET" || var_5 == "MOD_IMPACT" )
            return "getTweakableValue( game, onlyheadshots )";
        else if ( var_5 == "MOD_HEAD_SHOT" )
        {
            if ( var_2 maps\mp\_utility::isjuggernaut() )
                var_3 = 75;
            else
                var_3 = 150;
        }
    }

    if ( var_6 == "none" && isdefined( var_0 ) )
    {
        if ( isdefined( var_0.destructible_type ) && issubstr( var_0.destructible_type, "vehicle_" ) )
            var_6 = "destructible_car";
    }

    if ( var_6 == "destructible_toy" && isdefined( var_0 ) )
    {
        var_19 = var_0 getscriptabletypeforentity();

        if ( issubstr( var_19, "destpv_" ) )
            var_6 = "destructible_car";
    }

    if ( gettime() < var_2.spawntime + level.killstreakspawnshield )
    {
        var_20 = int( max( var_2.health / 4, 1 ) );

        if ( var_3 >= var_20 && maps\mp\_utility::iskillstreakweapon( var_6 ) && !maps\mp\_utility::ismeleemod( var_5 ) )
            var_3 = var_20;
    }

    if ( !( var_4 & level.idflags_no_protection ) )
    {
        if ( !level.teambased && var_17 && isdefined( var_1.owner ) && var_1.owner == var_2 )
        {
            if ( var_5 == "MOD_CRUSH" )
                var_2 maps\mp\_utility::_suicide();

            return "ffa suicide";
        }

        if ( ( issubstr( var_5, "MOD_GRENADE" ) || issubstr( var_5, "MOD_EXPLOSIVE" ) || issubstr( var_5, "MOD_PROJECTILE" ) ) && isdefined( var_0 ) && isdefined( var_1 ) )
        {
            if ( var_2 != var_1 && var_0.classname == "grenade" && var_2.lastspawntime + 3500 > gettime() && isdefined( var_2.lastspawnpoint ) && distance( var_0.origin, var_2.lastspawnpoint.origin ) < 250 )
                return "spawnkill grenade protection";

            if ( var_2 victimcanupdatefinalattackerdata( var_1 ) )
            {
                var_2.explosiveinfo = [];
                var_2.explosiveinfo["damageTime"] = gettime();
                var_2.explosiveinfo["damageId"] = var_0 getentitynumber();
                var_2.explosiveinfo["returnToSender"] = 0;
                var_2.explosiveinfo["counterKill"] = 0;
                var_2.explosiveinfo["chainKill"] = 0;
                var_2.explosiveinfo["cookedKill"] = 0;
                var_2.explosiveinfo["throwbackKill"] = 0;
                var_2.explosiveinfo["suicideGrenadeKill"] = 0;
                var_2.explosiveinfo["weapon"] = var_6;
                var_21 = issubstr( var_6, "h1_frag" );

                if ( var_1 != var_2 )
                {
                    if ( ( issubstr( var_6, "c4_" ) || issubstr( var_6, "claymore_" ) ) && isdefined( var_1 ) && isdefined( var_0.owner ) )
                    {
                        var_2.explosiveinfo["returnToSender"] = var_0.owner == var_2;
                        var_2.explosiveinfo["counterKill"] = isdefined( var_0.wasdamaged );
                        var_2.explosiveinfo["chainKill"] = isdefined( var_0.waschained );
                        var_2.explosiveinfo["bulletPenetrationKill"] = isdefined( var_0.wasdamagedfrombulletpenetration );
                        var_2.explosiveinfo["cookedKill"] = 0;
                    }

                    if ( isdefined( var_1.lastgrenadesuicidetime ) && var_1.lastgrenadesuicidetime >= gettime() - 50 && var_21 )
                        var_2.explosiveinfo["suicideGrenadeKill"] = 1;
                }

                if ( var_21 )
                {
                    var_2.explosiveinfo["cookedKill"] = isdefined( var_0.iscooked );
                    var_2.explosiveinfo["throwbackKill"] = isdefined( var_0.threwback );
                }

                var_2.explosiveinfo["stickKill"] = isdefined( var_0.isstuck ) && var_0.isstuck == "enemy";
                var_2.explosiveinfo["stickFriendlyKill"] = isdefined( var_0.isstuck ) && var_0.isstuck == "friendly";
            }

            if ( isplayer( var_1 ) && var_1 != self )
                maps\mp\gametypes\_gamelogic::setinflictorstat( var_0, var_1, var_6 );
        }

        if ( issubstr( var_5, "MOD_IMPACT" ) && ( var_6 == "m320_mp" || issubstr( var_6, "gl" ) || issubstr( var_6, "gp25" ) ) )
        {
            if ( isplayer( var_1 ) && var_1 != self )
                maps\mp\gametypes\_gamelogic::setinflictorstat( var_0, var_1, var_6 );
        }

        if ( isplayer( var_1 ) && isdefined( var_1.pers["participation"] ) )
            var_1.pers["participation"]++;
        else if ( isplayer( var_1 ) )
            var_1.pers["participation"] = 1;

        if ( var_12 )
        {
            if ( level.friendlyfire == 0 || !isplayer( var_1 ) && level.friendlyfire != 1 )
            {
                if ( var_6 == "artillery_mp" )
                    var_2 damageshellshockandrumble( var_0, var_6, var_5, var_3, var_4, var_1 );

                return "friendly fire";
            }
            else if ( level.friendlyfire == 1 )
            {
                if ( var_3 < 1 )
                    var_3 = 1;

                if ( var_2 maps\mp\_utility::isjuggernaut() )
                    var_3 = maps\mp\perks\_perks::cac_modified_damage( var_2, var_1, var_3, var_5, var_6, var_7, var_8, var_9 );

                var_2.lastdamagewasfromenemy = 0;
                var_2 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
            }
            else if ( level.friendlyfire == 2 && maps\mp\_utility::isreallyalive( var_1 ) )
            {
                var_3 = int( var_3 * 0.5 );

                if ( var_3 < 1 )
                    var_3 = 1;

                var_1.lastdamagewasfromenemy = 0;
                var_1.friendlydamage = 1;
                var_1 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
                var_1.friendlydamage = undefined;
            }
            else if ( level.friendlyfire == 3 && maps\mp\_utility::isreallyalive( var_1 ) )
            {
                var_3 = int( var_3 * 0.5 );

                if ( var_3 < 1 )
                    var_3 = 1;

                var_2.lastdamagewasfromenemy = 0;
                var_1.lastdamagewasfromenemy = 0;
                var_2 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );

                if ( maps\mp\_utility::isreallyalive( var_1 ) )
                {
                    var_1.friendlydamage = 1;
                    var_1 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
                    var_1.friendlydamage = undefined;
                }
            }

            var_18 = 1;
        }
        else
        {
            if ( var_3 < 1 )
                var_3 = 1;

            if ( isdefined( var_1 ) && isplayer( var_1 ) )
                addattacker( var_2, var_1, var_0, var_6, var_3, var_7, var_8, var_9, var_10, var_5 );

            if ( isdefined( var_1 ) && !isplayer( var_1 ) && isdefined( var_1.owner ) && ( !isdefined( var_1.scrambled ) || !var_1.scrambled ) )
                addattacker( var_2, var_1.owner, var_0, var_6, var_3, var_7, var_8, var_9, var_10, var_5 );
            else if ( isdefined( var_1 ) && !isplayer( var_1 ) && isdefined( var_1.secondowner ) && isdefined( var_1.scrambled ) && var_1.scrambled )
                addattacker( var_2, var_1.secondowner, var_0, var_6, var_3, var_7, var_8, var_9, var_10, var_5 );

            if ( var_5 == "MOD_EXPLOSIVE" || var_5 == "MOD_GRENADE_SPLASH" && var_3 < var_2.health )
                var_2 notify( "survived_explosion", var_1 );

            if ( isdefined( var_1 ) && isplayer( var_1 ) && isdefined( var_6 ) )
                var_1 thread maps\mp\gametypes\_weapons::checkhit( var_6, var_2 );

            if ( isdefined( var_1 ) && isPlayer( var_1 ) && isDefined( var_6 ) && var_1 != var_2 )
			{
				if(var_3 <= var_2.health)
					var_1.CustomDamage = int(var_1.CustomDamage + var_3);
				else
					var_1.CustomDamage = int(var_1.CustomDamage + var_2.health);
				var_2.attackerPosition = var_1.origin;
			}

            //var_0,      var_1,     var_2,  var_3,   var_4,    var_5,        var_6,   var_7,  var_8, var_9,  var_10 )

            //eInflictor, eAttacker, victim, iDamage, iDFlags, sMeansOfDeath, sWeapon, vPoint, vDir, sHitLoc, psOffsetTime

            if ( var_2 victimcanupdatefinalattackerdata( var_1 ) )
            {
                var_2.attackerposition = undefined;

                if ( isdefined( var_1 ) && isplayer( var_1 ) && isdefined( var_6 ) && var_1 != var_2 )
                    var_2.attackerposition = var_1.origin;

                if ( issubstr( var_5, "MOD_GRENADE" ) && isdefined( var_0 ) && isdefined( var_0.iscooked ) )
                    var_2.wascooked = gettime();
                else
                    var_2.wascooked = undefined;

                if ( issubstr( var_5, "MOD_IMPACT" ) && isdefined( var_0 ) && isdefined( var_0.recall ) && var_0.recall )
                    var_2.wasrecall = 1;
                else
                    var_2.wasrecall = 0;
            }

            var_2.lastdamagewasfromenemy = isdefined( var_1 ) && var_1 != var_2;

            if ( var_2.lastdamagewasfromenemy )
            {
                var_22 = gettime();
                var_1.damagedplayers[var_2.guid] = var_22;
                var_2.lastdamagedtime = var_22;
            }

            var_2 finishplayerdamagewrapper( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10, var_14 );
            var_2 thread maps\mp\gametypes\_missions::playerdamaged( var_0, var_1, var_3, var_5, var_6, var_9 );
        }

        if ( var_3 > 0 && var_5 != "MOD_FALLING" )
            var_2 setclientomnvar( "ui_damage_flash", 1 );

        if ( var_17 && isdefined( var_1.gunner ) )
            var_23 = var_1.gunner;
        else
            var_23 = var_1;

        if ( isdefined( var_23 ) && ( var_23 != var_2 || maps\mp\_utility::iskillstreakweapon( var_6 ) ) && var_3 > 0 && ( !isdefined( var_9 ) || var_9 != "shield" ) )
        {
            if ( !maps\mp\_utility::isreallyalive( var_2 ) )
                var_24 = "killshot";
            else if ( var_4 & level.idflags_stun )
                var_24 = "stun";
            else if ( isdefined( var_2.exo_health_on ) && var_2.exo_health_on == 1 )
                var_24 = "hitmorehealth";
            else if ( var_2 maps\mp\_utility::_hasperk( "specialty_armorvest" ) )
                var_24 = "hitmorehealth";
            else if ( isexplosivedamagemod( var_5 ) && var_2 maps\mp\_utility::_hasperk( "specialty_blastshield2" ) )
                var_24 = "hitblastshield";
            else if ( isdefined( var_2.lightarmorhp ) && var_5 != "MOD_HEAD_SHOT" && !maps\mp\_utility::isfmjdamage( var_6, var_5, var_1 ) )
                var_24 = "hitlightarmor";
            else if ( var_2 maps\mp\_utility::isjuggernaut() )
                var_24 = "hitjuggernaut";
            else if ( !shouldweaponfeedback( var_6 ) )
                var_24 = "none";
            else if ( isdefined( var_2.exo_health_on ) && var_2.exo_health_on )
                var_24 = "hitjuggernaut";
            else
                var_24 = "standard";

            var_23 thread maps\mp\gametypes\_damagefeedback::updatedamagefeedback( var_24 );
        }

        maps\mp\gametypes\_gamelogic::sethasdonecombat( var_2, 1 );
    }

    if ( isdefined( var_1 ) && var_1 != var_2 && !var_18 )
        level.usestartspawns = 0;

    if ( var_2.sessionstate != "dead" )
    {
        var_25 = var_2 getentitynumber();
        var_26 = var_2.name;
        var_27 = var_2.pers["team"];
        var_28 = var_2.guid;
        var_29 = "";

        if ( isplayer( var_1 ) )
        {
            var_30 = var_1 getentitynumber();
            var_31 = var_1.guid;
            var_32 = var_1.name;
            var_29 = var_1.pers["team"];
        }
        else
        {
            var_30 = -1;
            var_31 = "";
            var_32 = "";
            var_29 = "world";
        }

        if ( isplayer( var_1 ) )
        {
            var_33 = var_1.name;
            var_34 = var_1.origin;
            var_35 = var_1.lifeid;
        }
        else
        {
            var_33 = "world";
            var_34 = var_2.origin;
            var_35 = -1;
        }

        var_36 = gettime();

        if ( !isagent( var_2 ) && isdefined( var_2.spawninfo ) && isdefined( var_2.spawninfo.spawntime ) )
        {
            var_37 = ( var_36 - var_2.spawninfo.spawntime ) / 1000.0;

            if ( var_37 <= 3.0 && var_2.spawninfo.damagereceivedtoofast == 0 )
            {
                if ( !isdefined( level.matchdata ) )
                    level.matchdata = [];

                if ( !isdefined( level.matchdata["badSpawnDmgReceivedCount"] ) )
                    level.matchdata["badSpawnDmgReceivedCount"] = 1;
                else
                    level.matchdata["badSpawnDmgReceivedCount"]++;

                var_2.spawninfo.damagereceivedtoofast = 1;

                if ( var_2.spawninfo.badspawn == 0 )
                {
                    if ( !isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
                        level.matchdata["badSpawnByAnyMeansCount"] = 1;
                    else
                        level.matchdata["badSpawnByAnyMeansCount"]++;

                    var_2.spawninfo.badspawn = 1;
                }
            }
        }
        else
            var_37 = -1;

        if ( isdefined( var_1 ) && isdefined( var_1.spawninfo ) && isdefined( var_1.spawninfo.spawntime ) && isplayer( var_1 ) )
        {
            var_38 = ( var_36 - var_1.spawninfo.spawntime ) / 1000.0;

            if ( var_38 <= 3.0 && var_1.spawninfo.damagedealttoofast == 0 )
            {
                if ( !isdefined( level.matchdata ) )
                    level.matchdata = [];

                if ( !isdefined( level.matchdata["badSpawnDmgDealtCount"] ) )
                    level.matchdata["badSpawnDmgDealtCount"] = 1;
                else
                    level.matchdata["badSpawnDmgDealtCount"]++;

                var_1.spawninfo.damagedealttoofast = 1;

                if ( var_1.spawninfo.badspawn == 0 )
                {
                    if ( !isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
                        level.matchdata["badSpawnByAnyMeansCount"] = 1;
                    else
                        level.matchdata["badSpawnByAnyMeansCount"]++;

                    var_1.spawninfo.badspawn = 1;
                }
            }
        }
        else
            var_38 = -1;

        if ( !isagent( var_2 ) )
            reconspatialevent( var_2.origin, "script_mp_damage: player_name %s, player_angles %v, hit_loc %s, attacker_name %s, attacker_pos %v, damage %d, weapon %s, damage_type %s, gameTime %d, life_id %d, attacker_life_id %d, spawnToDamageReceivedTime %f, spawnToDamageDealtTime %f", var_2.name, var_2.angles, var_9, var_33, var_34, var_3, var_6, var_5, var_36, var_2.lifeid, var_35, var_37, var_38 );

        logprint( "D;" + var_28 + ";" + var_25 + ";" + var_27 + ";" + var_26 + ";" + var_31 + ";" + var_30 + ";" + var_29 + ";" + var_32 + ";" + var_6 + ";" + var_3 + ";" + var_5 + ";" + var_9 + "\\n" );
    }

    hitlocdebug( var_1, var_2, var_3, var_9, var_4 );

    if ( isagent( self ) )
        self [[ maps\mp\agents\_agent_utility::agentfunc( "on_damaged_finished" ) ]]( var_0, var_1, var_3, var_4, var_5, var_6, var_7, var_8, var_9, var_10 );

    return "finished";
}

gf_roundwinnerdialog()
{
    level waittill( "round_win", var_0 );
    var_1 = level.roundenddelay / 4;

    //if ( var_1 > 0 )
    //    wait(var_1);

    if ( !isdefined( var_0 ) || isplayer( var_0 ) )
        return;

    if ( var_0 == "allies" )
    {
        maps\mp\_utility::leaderdialog( "round_success", "allies" );
        maps\mp\_utility::leaderdialog( "round_failure", "axis" );
    }
    else if ( var_0 == "axis" )
    {
        maps\mp\_utility::leaderdialog( "round_success", "axis" );
        maps\mp\_utility::leaderdialog( "round_failure", "allies" );
    }
    else if ( var_0 == "tie" )
    {
        foreach(player in level.players){
            player playLocalSound(level.warn_draw);
        }
        if ( var_1 > 0 )
        wait(var_1);
    }
}

gf_endgame( var_0, var_1, var_2 )
{
    if ( !isdefined( var_2 ) )
        var_2 = 0;

    if ( game["state"] == "postgame" || level.gameended )
        return;

    game["state"] = "postgame";
    setdvar( "ui_game_state", "postgame" );
    level.gameendtime = gettime();
    level.gameended = 1;
    level.ingraceperiod = 0;
    level notify( "game_ended", var_0 );
    maps\mp\_utility::levelflagset( "game_over" );
    maps\mp\_utility::levelflagset( "block_notifies" );
    var_3 = getgameduration();
    setomnvar( "ui_game_duration", var_3 * 1000 );
    maps\mp\_utility::setgameplayactive( 0 );
    waitframe();
    setgameendtime( 0 );
    setmatchdata( "gameLengthSeconds", var_3 );
    setmatchdata( "endTimeUTC", getsystemtime() );
    checkgameendchallenges();

    if ( isdefined( var_0 ) && isstring( var_0 ) && maps\mp\_utility::isovertimetext( var_0 ) )
    {
        level.finalkillcam_winner = "none";
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();
        endgameovertime( var_0, var_1 );
        return;
    }

    if ( isdefined( var_0 ) && isstring( var_0 ) && var_0 == "halftime" )
    {
        level.finalkillcam_winner = "none";
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();
        endgamehalftime( var_1 );
        return;
    }

    if ( isdefined( level.finalkillcam_winner ) )
        level.finalkillcam_timegameended[level.finalkillcam_winner] = maps\mp\_utility::getsecondspassed();

    game["roundsPlayed"]++;

    if ( level.gametype != "ctf" )
        setomnvar( "ui_current_round", game["roundsPlayed"] );

    if ( level.teambased )
    {
        if ( ( var_0 == "axis" || var_0 == "allies" ) && level.gametype != "ctf" )
            game["roundsWon"][var_0]++;

        maps\mp\gametypes\_gamescore::updateteamscore( "axis" );
        maps\mp\gametypes\_gamescore::updateteamscore( "allies" );
    }
    else if ( isdefined( var_0 ) && isplayer( var_0 ) )
        game["roundsWon"][var_0.guid]++;

    axisWins = game["roundsWon"]["axis"];
    alliesWins = game["roundsWon"]["allies"];
    plus2winlimit = (getdvarint("scr_gf_winlimit"));
    if((axisWins > alliesWins && axisWins >= plus2winlimit) || (alliesWins > axisWins && alliesWins >= plus2winlimit))
        level.forcedend = 1;
    else if (axisWins == (plus2winlimit - 1) && alliesWins == (plus2winlimit - 1))
        setDvar("scr_gf_winlimit", getdvarint("scr_gf_winlimit") + 1);

    maps\mp\gametypes\_gamescore::updateplacement();
    rankedmatchupdates( var_0 );
    handlekillstreaksonroundswitch( 1 );

    foreach ( var_5 in level.players )
        var_5 setclientdvar( "ui_opensummary", 1 );

    setdvar( "g_deadChat", 1 );
    setdvar( "ui_allow_teamchange", 0 );
    setdvar( "bg_compassShowEnemies", 0 );
    freezeallplayers( 1.0, 1 );
    var_7 = game["switchedsides"];

    if ( !maps\mp\_utility::wasonlyround() && !var_2 )
    {
        displayroundend( var_0, var_1 );

        if ( isdefined( level.finalkillcam_winner ) )
        {
            foreach ( var_5 in level.players )
                var_5 notify( "reset_outcome" );

            level notify( "game_cleanup" );
            waittillfinalkillcamdone();
        }

        /*if(var_0 == "tie"){
            foreach(player in level.players){
                player playLocalSound(level.warn_draw);
            }
        }*/

        if ( !maps\mp\_utility::waslastround() )
        {
            maps\mp\_utility::levelflagclear( "block_notifies" );

            if ( checkroundswitch() )
                displayroundswitch( var_7 );

            foreach ( var_5 in level.players )
            {
                var_5.pers["stats"] = var_5.stats;
                var_5.pers["segments"] = var_5.segments;
            }

            level notify( "restarting" );
            game["state"] = "playing";
            setdvar( "ui_game_state", "playing" );
            map_restart( 1 );
            return;
        }

        if ( !level.forcedend )
            var_1 = updateendreasontext( var_0 );
    }

    if ( !isdefined( game["clientMatchDataDef"] ) )
    {
        game["clientMatchDataDef"] = "mp/clientmatchdata.ddl";
        setclientmatchdatadef( game["clientMatchDataDef"] );
    }

    maps\mp\gametypes\_missions::roundend( var_0 );
    var_0 = getgamewinner( var_0, 1 );

    if ( level.teambased )
    {
        setomnvar( "ui_game_victor", 0 );

        if ( var_0 == "allies" )
            setomnvar( "ui_game_victor", 2 );
        else if ( var_0 == "axis" )
            setomnvar( "ui_game_victor", 1 );
    }

    displaygameend( var_0, var_1 );
    var_12 = gettime();

    if ( isdefined( level.finalkillcam_winner ) && maps\mp\_utility::wasonlyround() )
    {
        foreach ( var_5 in level.players )
            var_5 notify( "reset_outcome" );

        level notify( "game_cleanup" );
        waittillfinalkillcamdone();
    }

    maps\mp\_utility::levelflagclear( "block_notifies" );
    level.intermission = 1;
    level notify( "spawning_intermission" );

    foreach ( var_5 in level.players )
    {
        var_5 closepopupmenu();
        var_5 closeingamemenu();
        var_5 notify( "reset_outcome" );
        var_5 setclientomnvar( "ui_toggle_final_scoreboard", 1 );
        var_5 thread maps\mp\gametypes\_playerlogic::spawnintermission();
    }

    processlobbydata();
    maps\mp\_skill::process();
    wait 1.0;
    checkforpersonalbests();
    updatecombatrecord();

    if ( level.teambased )
    {
        if ( var_0 == "axis" || var_0 == "allies" )
            setmatchdata( "victor", var_0 );
        else
            setmatchdata( "victor", "none" );

        setmatchdata( "alliesScore", game["teamScores"]["allies"] );
        setmatchdata( "axisScore", game["teamScores"]["axis"] );
        tournamentreportwinningteam( var_0 );
    }
    else
        setmatchdata( "victor", "none" );

    level maps\mp\_matchdata::endofgamesummarylogger();

    foreach ( var_5 in level.players )
    {
        if ( var_5 maps\mp\_utility::rankingenabled() )
            var_5 maps\mp\_matchdata::logfinalstats();

        var_5 maps\mp\gametypes\_playerlogic::logplayerstats();
    }

    setDvar("Same_Loudout_Count", (getdvarint("change_loudout_round")+1) );
    setDvar("gf_currentMap2", "");

    setmatchdata( "host", maps\mp\gametypes\_playerlogic::truncateplayername( level.hostname ) );

    if ( maps\mp\_utility::matchmakinggame() )
    {
        setmatchdata( "playlistVersion", getplaylistversion() );
        setmatchdata( "playlistID", getplaylistid() );
        setmatchdata( "isDedicated", isdedicatedserver() );
    }

    setmatchdata( "levelMaxClients", level.maxclients );
    sendmatchdata();
    var_19 = getmatchdata( "victor" );
    recordendgamecomscoreevent( var_19 );

    foreach ( var_5 in level.players )
    {
        var_5.pers["stats"] = var_5.stats;
        var_5.pers["segments"] = var_5.segments;
    }

    tournamentreportendofgame();
    var_22 = 0;

    if ( isdefined( level.endgamewaitfunc ) )
        [[ level.endgamewaitfunc ]]( var_2, level.postgamenotifies, var_22, var_0 );
    else if ( !var_2 && !level.postgamenotifies )
    {
        if ( !maps\mp\_utility::wasonlyround() )
            wait(6.0 + var_22);
        else
            wait(min( 10.0, 4.0 + var_22 + level.postgamenotifies ));
    }
    else
        wait(min( 10.0, 4.0 + var_22 + level.postgamenotifies ));

    var_23 = "_gamelogic.gsc";
    var_24 = "all";

    if ( level.teambased && isdefined( var_0 ) )
        var_24 = var_0;

    var_25 = "undefined";

    if ( isdefined( var_1 ) )
    {
        switch ( var_1 )
        {
            case 1:
                var_25 = "MP_SCORE_LIMIT_REACHED";
                break;
            case 2:
                var_25 = "MP_TIME_LIMIT_REACHED";
                break;
            case 3:
                var_25 = "MP_PLAYERS_FORFEITED";
                break;
            case 4:
                var_25 = "MP_TARGET_DESTROYED";
                break;
            case 5:
                var_25 = "MP_BOMB_DEFUSED";
                break;
            case 6:
                var_25 = "MP_SAS_ELIMINATED";
                break;
            case 7:
                var_25 = "MP_SPETSNAZ_ELIMINATED";
                break;
            case 8:
                var_25 = "MP_SAS_FORFEITED";
                break;
            case 9:
                var_25 = "MP_SPETSNAZ_FORFEITED";
                break;
            case 10:
                var_25 = "MP_SAS_MISSION_ACCOMPLISHED";
                break;
            case 11:
                var_25 = "MP_SPETSNAZ_MISSION_ACCOMPLISHED";
                break;
            case 12:
                var_25 = "MP_ENEMIES_ELIMINATED";
                break;
            case 13:
                var_25 = "MP_MATCH_TIE";
                break;
            case 14:
                var_25 = "GAME_OBJECTIVECOMPLETED";
                break;
            case 15:
                var_25 = "GAME_OBJECTIVEFAILED";
                break;
            case 16:
                var_25 = "MP_SWITCHING_SIDES";
                break;
            case 17:
                var_25 = "MP_ROUND_LIMIT_REACHED";
                break;
            case 18:
                var_25 = "MP_ENDED_GAME";
                break;
            case 19:
                var_25 = "MP_HOST_ENDED_GAME";
                break;
            case 20:
                var_25 = "MP_PREVENT_STAT_LOSS";
                break;
            default:
                break;
        }
    }

    if ( !isdefined( var_12 ) )
        var_12 = -1;

    var_26 = 15;
    var_27 = var_26;
    var_28 = getmatchdata( "playerCount" );
    var_29 = getmatchdata( "lifeCount" );

    if ( !isdefined( level.matchdata ) )
    {
        var_30 = 0;
        var_31 = 0;
        var_32 = 0;
        var_33 = 0;
        var_34 = 0;
        var_35 = 0;
        var_36 = 0;
    }
    else
    {
        if ( isdefined( level.matchdata["botJoinCount"] ) )
            var_30 = level.matchdata["botJoinCount"];
        else
            var_30 = 0;

        if ( isdefined( level.matchdata["deathCount"] ) )
            var_31 = level.matchdata["deathCount"];
        else
            var_31 = 0;

        if ( isdefined( level.matchdata["badSpawnDiedTooFastCount"] ) )
            var_32 = level.matchdata["badSpawnDiedTooFastCount"];
        else
            var_32 = 0;

        if ( isdefined( level.matchdata["badSpawnKilledTooFastCount"] ) )
            var_33 = level.matchdata["badSpawnKilledTooFastCount"];
        else
            var_33 = 0;

        if ( isdefined( level.matchdata["badSpawnDmgDealtCount"] ) )
            var_34 = level.matchdata["badSpawnDmgDealtCount"];
        else
            var_34 = 0;

        if ( isdefined( level.matchdata["badSpawnDmgReceivedCount"] ) )
            var_35 = level.matchdata["badSpawnDmgReceivedCount"];
        else
            var_35 = 0;

        if ( isdefined( level.matchdata["badSpawnByAnyMeansCount"] ) )
            var_36 = level.matchdata["badSpawnByAnyMeansCount"];
        else
            var_36 = 0;
    }

    var_37 = 0;
    reconevent( "script_mp_match_end: script_file %s, gameTime %d, match_winner %s, win_reason %s, version %d, joinCount %d, botJoinCount %d, spawnCount %d, deathCount %d, badSpawnDiedTooFastCount %d, badSpawnKilledTooFastCount %d, badSpawnDmgDealtCount %d, badSpawnDmgReceivedCount %d, badSpawnByAnyMeansCount %d, sightTraceMethodsUsed %d", var_23, var_12, var_24, var_25, var_27, var_28, var_30, var_29, var_31, var_32, var_33, var_34, var_35, var_36, var_37 );

    if ( isdefined( level.ishorde ) && level.ishorde )
    {
        if ( isdefined( level.zombiescompleted ) && level.zombiescompleted )
            setdvar( "cg_drawCrosshair", 1 );
    }

    level notify( "exitLevel_called" );
    exitlevel( 0 );
}

gf_startgame()
{
    thread gametimer();
    level.timerstopped = 0;
    level.timerstoppedforgamemode = 0;

    if ( maps\mp\gametypes\_legacyspawnlogic::uselegacyspawning() )
        thread maps\mp\gametypes\_legacyspawnlogic::spawnperframeupdate();

    setdvar( "ui_inprematch", 1 );
    prematchperiod();
    maps\mp\_utility::gameflagset( "prematch_done" );
    level notify( "prematch_over" );
    setdvar( "ui_inprematch", 0 );
    level.prematch_done_time = gettime();
    level.WaitingGFPlayers = false;
    while(level.manualAliveCount["allies"] < 1 || level.manualAliveCount["axis"] < 1){
        if(level.manualAliveCount["allies"] < 1 || level.manualAliveCount["axis"] < 1){
            level.WaitingGFPlayers = true;
            pauseTimer();
            //iPrintLnBold("^2Waiting for other players");
        }
        wait 0.1;
    }
    resumetimer();
    if(level.WaitingGFPlayers){
        setDvar("Same_Loudout_Count", 0 );
		thread user_scripts\mp_patches\gunfight\game::setupAllPlayers();
        thread matchstarttimer();
		level.WaitingGFPlayers = false;
    }
    updatetimerpausedness();
    thread timelimitclock();
    thread graceperiod();
    thread maps\mp\gametypes\_missions::roundbegin();
    thread maps\mp\_matchdata::matchstarted();
    var_0 = isdefined( level.ishorde ) && level.ishorde;
    var_1 = isdefined( level.iszombiegame ) && level.iszombiegame;

    if ( var_0 || var_1 )
        thread updategameduration();

    if ( !maps\mp\_utility::invirtuallobby() )
        level thread maps\mp\_utility::gameplayactivewatch();

    lootserviceonstartgame();
}

gf_timelimitclock()
{
    level endon( "game_ended" );
    wait 0.05;
    var_0 = spawn( "script_origin", ( 0.0, 0.0, 0.0 ) );
    var_0 hide();

    while ( game["state"] == "playing" )
    {
        if ( !level.timerstopped && maps\mp\_utility::gettimelimit() )
        {
            var_1 = gettimeremaining() / 1000;
            var_2 = int( var_1 + 0.5 );
            var_3 = int( maps\mp\_utility::gettimelimit() * 60 * 0.5 );

            if ( maps\mp\_utility::gethalftime() && var_2 > var_3 )
                var_2 -= var_3;

            if ( var_2 >= 30 && var_2 <= 60 )
                level notify( "match_ending_soon", "time" );

            /*if ( var_2 <= 10 || var_2 <= 30 && var_2 % 2 == 0 )
            {
                level notify( "match_ending_very_soon" );

                if ( var_2 == 0 )
                    break;

                var_0 playsound( "ui_mp_timer_countdown" );
            }*/
            if ( var_2 == 10 ){
                //foreach(player in level.players){
                //    player thread user_scripts\mp_patches\gunfight\utils::startExfilHeli();
                //    break;
                //}
            }

            if ( var_2 == 4 ){
                level thread gf_notifyTeamStatus();
            }

            //if ( var_2 == 1 ){
            //    level thread gf_notifyOvertime();
            //}

            if ( var_2 <= 3 )
            {
                level notify( "match_ending_very_soon" );

                if ( var_2 == 0 )
                    break;

                var_0 playsound( "ui_mp_timer_countdown" );
            }

            if ( var_1 - floor( var_1 ) >= 0.05 )
                wait(var_1 - floor( var_1 ));
        }

        wait 1.0;
    }
}

gf_notifyTeamStatus(){
    foreach(player in level.players){
        if(!player.isWinning)
            player playLocalSound(level.warn_losingFight);
        else if(player.isWinning)
            player playLocalSound(level.warn_winningFight);
    }
}

gf_notifyOvertime(){
    foreach(player in level.players){
        player playLocalSound(level.warn_overtime);
    }
}

gf_callback_startgametype()
{
    maps\mp\_load::main();
    maps\mp\_utility::levelflaginit( "round_over", 0 );
    maps\mp\_utility::levelflaginit( "game_over", 0 );
    maps\mp\_utility::levelflaginit( "block_notifies", 0 );
    level.prematchperiod = 0;
    level.prematchperiodend = 0;
    level.postgamenotifies = 0;
    level.intermission = 0;
    setdvar( "bg_compassShowEnemies", getdvar( "scr_game_forceuav" ) );

    if ( !isdefined( game["gamestarted"] ) )
    {
        game["clientid"] = 0;
        var_0 = getmapcustom( "allieschar" );

        if ( !isdefined( var_0 ) || var_0 == "" )
        {
            if ( !isdefined( game["allies"] ) )
                var_0 = "marines";
            else
                var_0 = game["allies"];
        }

        var_1 = getmapcustom( "axischar" );

        if ( !isdefined( var_1 ) || var_1 == "" )
        {
            if ( !isdefined( game["axis"] ) )
                var_1 = "opfor";
            else
                var_1 = game["axis"];
        }

        if ( level.multiteambased )
        {
            var_2 = getmapcustom( "allieschar" );

            if ( !isdefined( var_2 ) || var_2 == "" )
                var_2 = "delta_multicam";

            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
                game[level.teamnamelist[var_3]] = var_2;
        }

        game["allies"] = var_0;
        game["axis"] = var_1;

        if ( !isdefined( game["attackers"] ) || !isdefined( game["defenders"] ) )
            thread common_scripts\utility::error( "No attackers or defenders team defined in level .gsc." );

        if ( !isdefined( game["attackers"] ) )
            game["attackers"] = "allies";

        if ( !isdefined( game["defenders"] ) )
            game["defenders"] = "axis";

        if ( !isdefined( game["state"] ) )
            game["state"] = "playing";

        if ( level.teambased )
        {
            game["strings"]["waiting_for_teams"] = &"MP_WAITING_FOR_TEAMS";
            game["strings"]["opponent_forfeiting_in"] = &"MP_OPPONENT_FORFEITING_IN";
        }
        else
        {
            game["strings"]["waiting_for_teams"] = &"MP_WAITING_FOR_MORE_PLAYERS";
            game["strings"]["opponent_forfeiting_in"] = &"MP_OPPONENT_FORFEITING_IN";
        }

        game["strings"]["press_to_spawn"] = &"PLATFORM_PRESS_TO_SPAWN";
        game["strings"]["match_starting_in"] = &"MP_MATCH_STARTING_IN";
        game["strings"]["match_resuming_in"] = &"MP_MATCH_RESUMING_IN";
        game["strings"]["waiting_for_players"] = &"MP_WAITING_FOR_PLAYERS";
        game["strings"]["spawn_tag_wait"] = &"MP_SPAWN_TAG_WAIT";
        game["strings"]["spawn_next_round"] = &"MP_SPAWN_NEXT_ROUND";
        game["strings"]["waiting_to_spawn"] = &"MP_WAITING_TO_SPAWN";
        game["strings"]["match_starting"] = &"MP_MATCH_STARTING";
        game["strings"]["change_team"] = &"MP_CHANGE_TEAM_NEXT_SPAWN";
        game["strings"]["change_team_cancel"] = &"MP_CHANGE_TEAM_CANCEL";
        game["strings"]["change_team_wait"] = &"MP_CHANGE_TEAM_WAIT";
        game["strings"]["change_class"] = &"MP_CHANGE_CLASS_NEXT_SPAWN";
        game["strings"]["change_class_cancel"] = &"MP_CHANGE_CLASS_CANCEL";
        game["strings"]["change_class_wait"] = &"MP_CHANGE_CLASS_WAIT";
        game["strings"]["last_stand"] = &"MPUI_LAST_STAND";
        game["strings"]["final_stand"] = &"MPUI_FINAL_STAND";
        game["strings"]["cowards_way"] = &"PLATFORM_COWARDS_WAY_OUT";
        game["strings"]["tie"] = &"MP_MATCH_TIE";
        game["colors"]["blue"] = ( 0.25, 0.25, 0.75 );
        game["colors"]["red"] = ( 0.75, 0.25, 0.25 );
        game["colors"]["white"] = ( 1.0, 1.0, 1.0 );
        game["colors"]["black"] = ( 0.0, 0.0, 0.0 );
        game["colors"]["grey"] = ( 0.5, 0.5, 0.5 );
        game["colors"]["green"] = ( 0.25, 0.75, 0.25 );
        game["colors"]["yellow"] = ( 0.65, 0.65, 0.0 );
        game["colors"]["orange"] = ( 1.0, 0.45, 0.0 );
        game["colors"]["cyan"] = ( 0.35, 0.7, 0.9 );
        game["strings"]["allies_name"] = maps\mp\gametypes\_teams::getteamname( "allies" );
        game["icons"]["allies"] = maps\mp\gametypes\_teams::getteamicon( "allies" );
        game["colors"]["allies"] = maps\mp\gametypes\_teams::getteamcolor( "allies" );
        game["strings"]["axis_name"] = maps\mp\gametypes\_teams::getteamname( "axis" );
        game["icons"]["axis"] = maps\mp\gametypes\_teams::getteamicon( "axis" );
        game["colors"]["axis"] = maps\mp\gametypes\_teams::getteamcolor( "axis" );

        if ( game["colors"]["allies"] == ( 0.0, 0.0, 0.0 ) )
            game["colors"]["allies"] = ( 0.5, 0.5, 0.5 );

        if ( game["colors"]["axis"] == ( 0.0, 0.0, 0.0 ) )
            game["colors"]["axis"] = ( 0.5, 0.5, 0.5 );

        [[ level.onprecachegametype ]]();
        setdvarifuninitialized( "min_wait_for_players", 5 );

        if ( level.console )
        {
            if ( !level.splitscreen )
            {
                if ( isdedicatedserver() )
                    level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "graceperiod_ds" );
                else
                    level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "graceperiod" );

                level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "matchstarttime" );
            }
        }
        else
        {
            if ( isdedicatedserver() )
                level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "playerwaittime_ds" );
            else
                level.prematchperiod = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "playerwaittime" );

            level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "matchstarttime" );
        }
    }
    else
    {
        setdvarifuninitialized( "min_wait_for_players", 3 );

        if ( level.console )
        {
            if ( !level.splitscreen )
            {
                level.prematchperiod = 5;
                level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "roundstarttime" );
            }
        }
        else
        {
            level.prematchperiod = 5;
            level.prematchperiodend = maps\mp\gametypes\_tweakables::gettweakablevalue( "game", "roundstarttime" );
        }
    }

    if ( !isdefined( game["status"] ) )
        game["status"] = "normal";

    if ( game["status"] != "overtime" && game["status"] != "halftime" && game["status"] != "overtime_halftime" )
    {
        game["teamScores"]["allies"] = 0;
        game["teamScores"]["axis"] = 0;

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
                game["teamScores"][level.teamnamelist[var_3]] = 0;
        }
    }

    if ( !isdefined( game["timePassed"] ) )
        game["timePassed"] = 0;

    if ( !isdefined( game["roundsPlayed"] ) )
        game["roundsPlayed"] = 0;

    setomnvar( "ui_current_round", game["roundsPlayed"] + 1 );

    if ( !isdefined( game["roundsWon"] ) )
        game["roundsWon"] = [];

    if ( level.teambased )
    {
        if ( !isdefined( game["roundsWon"]["axis"] ) )
            game["roundsWon"]["axis"] = 0;

        if ( !isdefined( game["roundsWon"]["allies"] ) )
            game["roundsWon"]["allies"] = 0;

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
            {
                if ( !isdefined( game["roundsWon"][level.teamnamelist[var_3]] ) )
                    game["roundsWon"][level.teamnamelist[var_3]] = 0;
            }
        }
    }

    level.gameended = 0;
    level.forcedend = 0;
    level.hostforcedend = 0;
    level.hardcoremode = getdvarint( "g_hardcore" );

    if ( level.hardcoremode )
        logstring( "game mode: hardcore" );

    level.oldschool = getdvarint( "g_oldschool" );

    if ( level.oldschool )
        logstring( "game mode: oldschool" );

    level.diehardmode = getdvarint( "scr_diehard" );

    if ( !level.teambased )
        level.diehardmode = 0;

    if ( level.diehardmode )
        logstring( "game mode: diehard" );

    level.killstreakrewards = getdvarint( "scr_game_hardpoints" );

    if ( !isdefined( level.iszombiegame ) )
        level.iszombiegame = 0;

    level.usestartspawns = 1;
    level.objectivepointsmod = 1;
    level.baseplayermovescale = 1;
    level.maxallowedteamkills = 2;
    thread maps\mp\gametypes\_hodgepodge::init();
    thread maps\mp\gametypes\_persistence::init();
    thread maps\mp\gametypes\_menus::init();
    thread maps\mp\gametypes\_hud::init();
    thread maps\mp\gametypes\_serversettings::init();
    thread maps\mp\gametypes\_teams::init();
    thread maps\mp\gametypes\_weapons::init();
    thread maps\mp\gametypes\_killcam::init();
    thread maps\mp\gametypes\_shellshock::init();
    thread maps\mp\gametypes\_deathicons::init();
    thread maps\mp\gametypes\_damagefeedback::init();
    thread maps\mp\gametypes\_healthoverlay::init();
    thread maps\mp\gametypes\_spectating::init();
    thread maps\mp\gametypes\_objpoints::init();
    thread maps\mp\gametypes\_gameobjects::init();
    thread maps\mp\gametypes\_spawnlogic::init();
    thread maps\mp\gametypes\_oldschool::init();
    thread maps\mp\gametypes\_battlechatter_mp::init();
    thread maps\mp\gametypes\_music_and_dialog::init();
    thread maps\mp\_matchdata::init();
    thread maps\mp\_awards::init();
    thread maps\mp\_skill::init();
    thread maps\mp\_areas::init();
    thread maps\mp\perks\_perks::init();
    thread maps\mp\_events::init();
    thread maps\mp\gametypes\_damage::initfinalkillcam();
    thread maps\mp\_snd_common_mp::init();
    thread maps\mp\_utility::buildattachmentmaps();

    if ( level.teambased )
        thread maps\mp\gametypes\_friendicons::init();

    thread maps\mp\gametypes\_hud_message::init();
    thread maps\mp\gametypes\_divisions::init();
    thread maps\mp\gametypes\_hardpoints::init();

    foreach ( var_5 in game["strings"] )
        precachestring( var_5 );

    game["gamestarted"] = 1;

    if ( !isdefined( game["absoluteStartTime"] ) )
        game["absoluteStartTime"] = getsystemtime();

    level.maxplayercount = 0;
    level.wavedelay["allies"] = 0;
    level.wavedelay["axis"] = 0;
    level.lastwave["allies"] = 0;
    level.lastwave["axis"] = 0;
    level.waveplayerspawnindex["allies"] = 0;
    level.waveplayerspawnindex["axis"] = 0;
    level.aliveplayers["allies"] = [];
    level.aliveplayers["axis"] = [];
    level.activeplayers = [];

    if ( level.multiteambased )
    {
        for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
        {
            level._wavedelay[level.teamnamelist[var_3]] = 0;
            level._lastwave[level.teamnamelist[var_3]] = 0;
            level._waveplayerspawnindex[level.teamnamelist[var_3]] = 0;
            level._aliveplayers[level.teamnamelist[var_3]] = [];
        }
    }

    setdvar( "ui_scorelimit", 0 );
    setdvar( "ui_allow_teamchange", 1 );

    if ( maps\mp\_utility::getgametypenumlives() )
        setdvar( "g_deadChat", 0 );
    else
        setdvar( "g_deadChat", 1 );

    var_7 = getdvarfloat( "scr_" + level.gametype + "_waverespawndelay" );

    if ( var_7 > 0 )
    {
        level.wavedelay["allies"] = var_7;
        level.wavedelay["axis"] = var_7;
        level.lastwave["allies"] = 0;
        level.lastwave["axis"] = 0;

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
            {
                level._wavedelay[level.teamnamelist[var_3]] = var_7;
                level._lastwave[level.teamnamelist[var_3]] = 0;
            }
        }

        level thread wavespawntimer();
    }

    maps\mp\_utility::gameflaginit( "prematch_done", 0 );
    level.graceperiod = 3;
    level.ingraceperiod = level.graceperiod;
    maps\mp\_utility::gameflaginit( "graceperiod_done", 0 );
    level.roundenddelay = 1;
    level.halftimeroundenddelay = 1;
    level.noragdollents = getentarray( "noragdoll", "targetname" );

    if ( level.teambased )
    {
        maps\mp\gametypes\_gamescore::updateteamscore( "axis" );
        maps\mp\gametypes\_gamescore::updateteamscore( "allies" );

        if ( level.multiteambased )
        {
            for ( var_3 = 0; var_3 < level.teamnamelist.size; var_3++ )
                maps\mp\gametypes\_gamescore::updateteamscore( level.teamnamelist[var_3] );
        }
    }
    else
        thread maps\mp\gametypes\_gamescore::initialdmscoreupdate();

    thread updateuiscorelimit();
    level notify( "update_scorelimit" );
    [[ level.onstartgametype ]]();
    level.scorepercentagecutoff = getdvarint( "scr_" + level.gametype + "_score_percentage_cut_off", 80 );
    level.timepercentagecutoff = getdvarint( "scr_" + level.gametype + "_time_percentage_cut_off", 80 );

    if ( !level.console && ( getdvar( "dedicated" ) == "dedicated LAN server" || getdvar( "dedicated" ) == "dedicated internet server" ) )
        thread verifydedicatedconfiguration();

    setattackingteam();
    thread startgame();
    level thread maps\mp\_utility::updatewatcheddvars();
    level thread timelimitthread();
    level thread maps\mp\gametypes\_damage::dofinalkillcam();
}

gf_matchstarttimer( var_0 )
{
    var_0 = 3;
    if(getDvar("gf_currentMap2") != getDvar("mapname")){
		setDvar("gf_currentMap2", getDvar("mapname"));
        var_0 = 15;
	}
    self notify( "matchStartTimer" );
    self endon( "matchStartTimer" );
    level notify( "match_start_timer_beginning" );
    var_1 = int( var_0 );
    childthread matchstartvisionfadeout( var_1 );

    if ( var_1 >= 2 )
        matchstarttimer_internal( var_1 );
    else
    {
        if ( level.currentgen )
            setomnvar( "ui_cg_world_blur_fade_out", 1 );

        if ( !maps\mp\_utility::privatematch() && !maps\mp\_utility::is_true( level.ishorde ) && !maps\mp\_utility::is_true( level.iszombiegame ) )
        {
            if ( level.xpscale > 1 )
            {
                foreach ( var_3 in level.players )
                    var_3 thread maps\mp\gametypes\_hud_message::splashnotify( "double_xp" );
            }
            else if ( level.xpscalewithparty > 1 )
            {
                foreach ( var_3 in level.players )
                {
                    if ( maps\mp\_utility::is_true( var_3.inpartywithotherplayers ) )
                        var_3 thread maps\mp\gametypes\_hud_message::splashnotify( "double_xp" );
                }
            }
        }
    }
}


balanceteams()
{
    var_0 = [];
    var_1 = [];
    var_2 = level.players;

    for ( var_3 = 0; var_3 < var_2.size; var_3++ )
    {
        if ( isdefined( var_2[var_3].pers["team"] ) && var_2[var_3].pers["team"] == "allies" )
        {
            var_0[var_0.size] = var_2[var_3];
            continue;
        }

        if ( isdefined( var_2[var_3].pers["team"] ) && var_2[var_3].pers["team"] == "axis" )
            var_1[var_1.size] = var_2[var_3];
    }

    var_4 = undefined;

    while ( var_0.size > var_1.size + 1 || var_1.size > var_0.size + 1 )
    {
        if ( var_0.size > var_1.size + 1 )
        {
            for ( var_5 = 0; var_5 < var_0.size; var_5++ )
            {
                if ( isdefined( var_0[var_5].dont_auto_balance ) )
                    continue;

                if ( !isdefined( var_4 ) )
                {
                    var_4 = var_0[var_5];
                    continue;
                }

                if ( var_0[var_5].pers["teamTime"] > var_4.pers["teamTime"] )
                    var_4 = var_0[var_5];
            }

            var_4 maps\mp\gametypes\_menus::addToTeam( "axis" );
        }
        else if ( var_1.size > var_0.size + 1 )
        {
            for ( var_5 = 0; var_5 < var_1.size; var_5++ )
            {
                if ( isdefined( var_1[var_5].dont_auto_balance ) )
                    continue;

                if ( !isdefined( var_4 ) )
                {
                    var_4 = var_1[var_5];
                    continue;
                }

                if ( var_1[var_5].pers["teamTime"] > var_4.pers["teamTime"] )
                    var_4 = var_1[var_5];
            }

            var_4 maps\mp\gametypes\_menus::addToTeam( "allies" );
        }

        var_4 = undefined;
        var_0 = [];
        var_1 = [];
        var_2 = level.players;

        for ( var_3 = 0; var_3 < var_2.size; var_3++ )
        {
            if ( isdefined( var_2[var_3].pers["team"] ) && var_2[var_3].pers["team"] == "allies" )
            {
                var_0[var_0.size] = var_2[var_3];
                continue;
            }

            if ( isdefined( var_2[var_3].pers["team"] ) && var_2[var_3].pers["team"] == "axis" )
                var_1[var_1.size] = var_2[var_3];
        }
		wait 0.025;
    }
}

checkSingleTeam(){
    level.team["allies"] = 0;
    level.team["axis"] = 0;
    players = level.players;
    for(i = 0; i < players.size; i++)
    {
        if((isdefined(players[i].pers["team"])) && (players[i].pers["team"] == "allies"))
            level.team["allies"]++;
        else if((isdefined(players[i].pers["team"])) && (players[i].pers["team"] == "axis"))
            level.team["axis"]++;
    }

    setDvar("gf_singleTeamPlayer", "none");
    if((level.team["allies"] == 1 && level.team["axis"] >= 2) || (level.team["axis"] == 1 && level.team["allies"] >= 2)){
        foreach(player in level.players){
            if(player.team == "allies" && level.team["allies"] == 1 && level.team["axis"] >= 2)
                setDvar("gf_singleTeamPlayer", player.guid);
            else if(player.team == "axis" && level.team["axis"] == 1 && level.team["allies"] >= 2)
                setDvar("gf_singleTeamPlayer", player.guid);
        }
    }
    
}

moveSinglePlayerTeam(){
    level.team["allies"] = 0;
    level.team["axis"] = 0;
    players = level.players;
    level.newSpawn1 = undefined;
    level.newSpawn2 = undefined;
    level.newAngle1 = undefined;
    level.newAngle2 = undefined;
    for(i = 0; i < players.size; i++)
    {
        if((isdefined(players[i].pers["team"])) && (players[i].pers["team"] == "allies"))
            level.team["allies"]++;
        else if((isdefined(players[i].pers["team"])) && (players[i].pers["team"] == "axis"))
            level.team["axis"]++;
    }

    if((level.team["allies"] == 1 && level.team["axis"] >= 2) || (level.team["axis"] == 1 && level.team["allies"] >= 2)){
        foreach(player in level.players){
            if(getDvar("gf_singleTeamPlayer") == player.guid && player.team == "allies" && level.team["allies"] == 1 && level.team["axis"] >= 2){
                level.newSpawn1 = player.origin;
                level.newAngle1 = player.angles;
                level moveNewSinglePlayer();
                player maps\mp\gametypes\_menus::addToTeam( "axis" );
                player setOrigin(level.newSpawn2);
                player setPlayerAngles(level.newAngle2);
                break;
            }
            else if(getDvar("gf_singleTeamPlayer") == player.guid && player.team == "axis" && level.team["axis"] == 1 && level.team["allies"] >= 2){
                level.newSpawn1 = player.origin;
                level.newAngle1 = player.angles;
                level moveNewSinglePlayer();
                player maps\mp\gametypes\_menus::addToTeam( "allies" );
                player setOrigin(level.newSpawn2);
                player setPlayerAngles(level.newAngle2);
                break;
            }
        }
    }
}

moveNewSinglePlayer(){
    var_0 = level.players[randomInt(level.players.size)];
    while(var_0.guid == getDvar("gf_singleTeamPlayer"))
        var_0 = level.players[randomInt(level.players.size)];
    
    //iPrintLn("A: "+var_0.guid);
    //iPrintLn("B: "+getDvar("gf_singleTeamPlayer"));

    if(var_0.team == "allies"){
        level.newSpawn2 = var_0.origin;
        level.newAngle2 = var_0.angles;
        var_0 maps\mp\gametypes\_menus::addToTeam( "axis" );
        var_0 setOrigin(level.newSpawn1);
        var_0 setPlayerAngles(level.newAngle1);
        setDvar("gf_singleTeamPlayer", "none");
    }
    else if(var_0.team == "axis"){
        level.newSpawn2 = var_0.origin;
        level.newAngle2 = var_0.angles;
        var_0 maps\mp\gametypes\_menus::addToTeam( "allies" );
        var_0 setOrigin(level.newSpawn1);
        var_0 setPlayerAngles(level.newAngle1);
        setDvar("gf_singleTeamPlayer", "none");
    }
}

gf_matchstarttimer_internal( var_0 )
{
    waittillframeend;
    level endon( "match_start_timer_beginning" );
    setomnvar( "ui_match_countdown_title", 1 );
    setomnvar( "ui_match_countdown_toggle", 1 );

    level.matchBeginTimer = var_0;

    while(!level.startRoundTimer)
        wait 0.1;

    while ( var_0 > 0 && !level.gameended )
    {
        setomnvar( "ui_match_countdown", var_0 );
        if(var_0 == 3){
            if(getDvar("gf_currentMap3") != getDvar("mapname")){
                setDvar("gf_currentMap3", getDvar("mapname"));
                level moveSinglePlayerTeam();
            }
        }
        var_0--;
        //level.matchBeginTimer = var_0;

        if ( level.currentgen )
            setomnvar( "ui_cg_world_blur", 1 );

        wait 1;
    }
    level.matchBeginTimer = 0;

    if ( level.currentgen )
        setomnvar( "ui_cg_world_blur_fade_out", 1 );

    if ( !maps\mp\_utility::privatematch() && !maps\mp\_utility::is_true( level.ishorde ) && !maps\mp\_utility::is_true( level.iszombiegame ) )
    {
        if ( level.xpscale > 1 )
        {
            foreach ( var_2 in level.players )
                var_2 thread maps\mp\gametypes\_hud_message::splashnotify( "double_xp" );
        }
        else if ( level.xpscalewithparty > 1 )
        {
            foreach ( var_2 in level.players )
            {
                if ( maps\mp\_utility::is_true( var_2.inpartywithotherplayers ) )
                    var_2 thread maps\mp\gametypes\_hud_message::splashnotify( "double_xp" );
            }
        }
    }

    setomnvar( "ui_match_countdown_toggle", 0 );
    setomnvar( "ui_match_countdown", 0 );
    setomnvar( "ui_match_countdown_title", 0 );
}

gf_onstartgametype()
{
    if ( !isdefined( game["switchedsides"] ) )
        game["switchedsides"] = 0;

    if ( game["switchedsides"] )
    {
        var_0 = game["attackers"];
        var_1 = game["defenders"];
        game["attackers"] = var_1;
        game["defenders"] = var_0;
    }

    setclientnamemode( "manual_change" );
    //maps\mp\gametypes\common_bomb_gameobject::loadbombfx();
    //maps\mp\_utility::setobjectivetext( game["attackers"], &"OBJECTIVES_SD_ATTACKER" );
    //maps\mp\_utility::setobjectivetext( game["defenders"], &"OBJECTIVES_SD_DEFENDER" );
    /*
    if ( level.splitscreen )
    {
        maps\mp\_utility::setobjectivescoretext( game["attackers"], &"OBJECTIVES_SD_ATTACKER" );
        maps\mp\_utility::setobjectivescoretext( game["defenders"], &"OBJECTIVES_SD_DEFENDER" );
    }
    else
    {
        maps\mp\_utility::setobjectivescoretext( game["attackers"], &"OBJECTIVES_SD_ATTACKER_SCORE" );
        maps\mp\_utility::setobjectivescoretext( game["defenders"], &"OBJECTIVES_SD_DEFENDER_SCORE" );
    }
    */
    //maps\mp\_utility::setobjectivehinttext( game["attackers"], &"OBJECTIVES_SD_ATTACKER_HINT" );
    //maps\mp\_utility::setobjectivehinttext( game["defenders"], &"OBJECTIVES_SD_DEFENDER_HINT" );
    initspawns();
    var_2[0] = "sd";
    var_2[1] = "bombzone";
    var_2[2] = "blocker";
    maps\mp\gametypes\_gameobjects::main( var_2 );
    thread maps\mp\gametypes\common_sd_sr::updategametypedvars();
    maps\mp\_utility::setcarrierloadouts();
    thread maps\mp\gametypes\common_sd_sr::bombs();
    thread maps\mp\gametypes\_spectating::allowallyteamspectating();
}

gf_ontimelimit()
{
    if(!level.gfOvertime){
        level.gfOvertime = true;
        sd_endgame( game["defenders"], game["end_reason"]["time_limit_reached"] );
    }
}

gf_sd_endgame( winningTeam, endReasonText, checkFlag )
{
    if(!isDefined(checkFlag))
        checkFlag = true;
    level balanceteams();
    level waittill("updated_player_count");
    if(level.manualAliveCount["allies"] > 0 && level.manualAliveCount["axis"] > 0 && checkFlag){
		level notify("begin_overtime");
        level.overtime = true;
        level.inOverTime = true;
		level waittill("overtime_over");
	}
    if(level.FlagOverride)
        wait 2;
    level thread checkSingleTeam();
	if(!level.FlagOverride){
		level.AlliesHealth = 0;
		level.AxisHealth = 0;
		foreach(player in level.players){
			if(player.team == "allies")
				level.AlliesHealth += player.health;
			if(player.team == "axis")
				level.AxisHealth += player.health;
		}
		if(getdvar("gf_healthmode") == "percent"){
			if(level.manualAliveCount["allies"] == 0 && level.manualAliveCount["axis"] > 0){
				winningTeam = "axis";
				endReasonText = "Axis Eliminated Allies";
			}
			else if(level.manualAliveCount["allies"] > 0 && level.manualAliveCount["axis"] == 0){
				winningTeam = "allies";
				endReasonText = "Allies Eliminated Axis";
			}
			else if(int((level.AxisHealth/level.AxisMaxHealth)*100) < int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
				winningTeam = "allies";
				endReasonText = "Highest Health Percent Wins";
			}
			else if(int((level.AxisHealth/level.AxisMaxHealth)*100) > int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
				winningTeam = "axis";
				endReasonText = "Highest Health Percent Wins";
			}
			else if(int((level.AxisHealth/level.AxisMaxHealth)*100) == int((level.AlliesHealth/level.AlliesMaxHealth)*100)){
				winningTeam = "tie";
				endReasonText = "Health Percentages Are Equal";
			}
		}
		else{
			if(level.manualAliveCount["allies"] == 0 && level.manualAliveCount["axis"] > 0){
				winningTeam = "axis";
				endReasonText = "Axis Eliminated Allies";
			}
			else if(level.manualAliveCount["allies"] > 0 && level.manualAliveCount["axis"] == 0){
				winningTeam = "allies";
				endReasonText = "Allies Eliminated Axis";
			}
			else if(level.AxisHealth < level.AlliesHealth){
				winningTeam = "allies";
				endReasonText = "Highest Health Wins";
			}
			else if(level.AxisHealth > level.AlliesHealth){
				winningTeam = "axis";
				endReasonText = "Highest Health Wins";
			}
			else if(level.AxisHealth == level.AlliesHealth){
				winningTeam = "tie";
				endReasonText = "Healths Are Equal";
			}
		}
	}
	else if(level.FlagOverride){
		winningTeam = level.OverrideWinners;
		endReasonText = winningTeam+" captured the flag";
	}
    level.finalkillcam_winner = winningTeam;											
	thread gf_endGame( winningTeam, endReasonText );
}

gf_bombs()
{
    level.bombplanted = 0;
    level.bombdefused = 0;
    level.bombexploded = 0;
    var_0 = getent( "sd_bomb_pickup_trig", "targetname" );

    if ( !isdefined( var_0 ) )
    {
        common_scripts\utility::error( "No sd_bomb_pickup_trig trigger found in map." );
        return;
    }

    var_1 = maps\mp\gametypes\common_bomb_gameobject::getcarrybombvisuals( "sd_bomb" );

    if ( !isdefined( var_1 ) )
    {
        common_scripts\utility::error( "No sd_bomb script_model found in map." );
        return;
    }

    if ( !level.multibomb )
    {
        //level.sdbomb = maps\mp\gametypes\common_bomb_gameobject::createbombcarryobject( game["attackers"], "friendly", var_0, var_1 );
        //thread maps\mp\_utility::streamcarrierweaponstoplayers( level.sdbomb, [ game["attackers"] ], ::shouldstreamcarrierclasstoplayer );

        //if ( game["attackers"] == "allies" )
        //    maps\mp\_utility::setmlgicons( level.sdbomb, "waypoint_bomb_green" );
        //else
        //    maps\mp\_utility::setmlgicons( level.sdbomb, "waypoint_bomb_red" );

        //level.sdbomb.onpickup = ::onpickup;
        //level.sdbomb.ondrop = ::ondrop;
    }
    else
    {
        var_0 delete();
        var_1[0] delete();
    }

    level.bombzones = [];
    var_2 = getentarray( "bombzone", "targetname" );
    var_3 = getentarray( "bombzone_augmented", "targetname" );

    if ( maps\mp\_utility::isaugmentedgamemode() )
    {
        for ( var_4 = 0; var_4 < var_3.size; var_4++ )
        {
            var_5 = var_3[var_4].script_label;

            for ( var_6 = 0; var_6 < var_2.size; var_6++ )
            {
                if ( var_2[var_6].script_label == var_5 )
                {
                    removebombzone( var_2[var_6] );
                    break;
                }
            }
        }
    }
    else
    {
        for ( var_7 = 0; var_7 < var_3.size; var_7++ )
            removebombzone( var_3[var_7] );
    }

    var_2 = common_scripts\utility::array_combine( var_2, var_3 );

    for ( var_7 = 0; var_7 < var_2.size; var_7++ )
    {
        var_0 = var_2[var_7];
        var_1 = getentarray( var_2[var_7].target, "targetname" );
        var_8 = undefined;

        if ( !level.multibomb )
            var_8 = level.sdbomb;

        //var_9 = maps\mp\gametypes\common_bomb_gameobject::createbombzoneobject( game["defenders"], "enemy", "any", var_0, var_8, 1 );
        var_9 = undefined;
        maps\mp\_utility::setmlgicons( var_9, "waypoint_esports_snd_target" + var_9.label + "_white" );
        var_9.onbeginuse = ::onbeginuse;
        var_9.onenduse = ::onenduse;
        var_9.onuse = ::onuseplantobject;
        var_9.oncantuse = ::oncantuse;
        level.bombzones[level.bombzones.size] = var_9;
        var_9.bombdefusetrig = getent( var_1[0].target, "targetname" );
        var_9.bombdefusetrig.origin += ( 0.0, 0.0, -10000.0 );
        var_9.bombdefusetrig.label = var_9.label;
        var_9.bombdefusetrig usetriggertouchcheckstance( 1 );
    }

    for ( var_7 = 0; var_7 < level.bombzones.size; var_7++ )
    {
        var_10 = [];

        for ( var_11 = 0; var_11 < level.bombzones.size; var_11++ )
        {
            if ( var_11 != var_7 )
                var_10[var_10.size] = level.bombzones[var_11];
        }

        level.bombzones[var_7].otherbombzones = var_10;
    }

    setomnvar( "ui_mlg_game_mode_status_1", 0 );
}